/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4970;

public class HangingColumnWithBaseConfig
implements class_3037 {
    public static final Codec<HangingColumnWithBaseConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("base_block_provider").forGetter(config -> config.baseBlockProvider), (App)class_4651.field_24937.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)class_4651.field_24937.fieldOf("end_block_provider").forGetter(config -> config.endBlockProvider), (App)Codec.INT.fieldOf("min_length").forGetter(config -> config.minLength), (App)Codec.INT.fieldOf("max_length").forGetter(config -> config.maxLength), (App)class_2680.field_24734.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()))).apply((Applicative)codecRecorder, HangingColumnWithBaseConfig::new));
    private final class_4651 baseBlockProvider;
    private final class_4651 blockProvider;
    private final class_4651 endBlockProvider;
    private final int minLength;
    private final int maxLength;
    private final Set<class_2248> whitelist;

    HangingColumnWithBaseConfig(class_4651 baseBlockProvider, class_4651 blockProvider, class_4651 endBlockProvider, int minLength, int maxLength, List<class_2680> whitelist) {
        this.baseBlockProvider = baseBlockProvider;
        this.blockProvider = blockProvider;
        this.endBlockProvider = endBlockProvider;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.whitelist = whitelist.stream().map(class_4970.class_4971::method_26204).collect(Collectors.toSet());
    }

    public class_4651 getBaseBlockProvider() {
        return this.baseBlockProvider;
    }

    public class_4651 getBlockProvider() {
        return this.blockProvider;
    }

    public class_4651 getEndBlockProvider() {
        return this.endBlockProvider;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxPossibleLength() {
        int returnValue = this.minLength - this.maxLength;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public Set<class_2248> getWhitelist() {
        return this.whitelist;
    }

    public static class Builder {
        private class_4651 baseBlockProvider = class_4656.method_38433((class_2680)class_2246.field_10431.method_9564());
        private class_4651 blockProvider = class_4656.method_38433((class_2680)class_2246.field_10503.method_9564());
        private class_4651 endBlockProvider = class_4656.method_38433((class_2680)class_2246.field_10124.method_9564());
        private List<class_2248> whitelist = ImmutableList.of((Object)class_2246.field_10219);
        private int minLength = 1;
        private int maxLength = 9;

        public Builder setBaseBlock(class_2248 block) {
            this.baseBlockProvider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBaseBlock(class_2680 state) {
            this.baseBlockProvider = state != null ? class_4656.method_38433((class_2680)state) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBaseBlock(class_4651 provider) {
            this.baseBlockProvider = provider != null ? provider : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2248 block) {
            this.blockProvider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2680 state) {
            this.blockProvider = state != null ? class_4656.method_38433((class_2680)state) : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_4651 provider) {
            this.blockProvider = provider != null ? provider : class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setEndBlock(class_2248 block) {
            this.endBlockProvider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : this.blockProvider;
            return this;
        }

        public Builder setEndBlock(class_2680 state) {
            this.endBlockProvider = state != null ? class_4656.method_38433((class_2680)state) : this.blockProvider;
            return this;
        }

        public Builder setEndBlock(class_4651 provider) {
            this.endBlockProvider = provider != null ? provider : this.blockProvider;
            return this;
        }

        public Builder setMinLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder setMaxLength(int maxPossibleHeight) {
            this.maxLength = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setWhitelist(ImmutableList<class_2248> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(HangingColumnWithBaseConfig config) {
            this.baseBlockProvider = config.baseBlockProvider;
            this.blockProvider = config.blockProvider;
            this.endBlockProvider = config.endBlockProvider;
            this.minLength = config.minLength;
            this.maxLength = config.maxLength;
            this.whitelist = ImmutableList.copyOf(config.whitelist);
            return this;
        }

        public HangingColumnWithBaseConfig build() {
            return new HangingColumnWithBaseConfig(this.baseBlockProvider, this.blockProvider, this.endBlockProvider, this.minLength, this.maxLength, this.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()));
        }
    }
}

